function [ecg RVepInt RVenInt LVepInt LVenInt] = ecgGen(t,p,debug)

% ecg = ecgGen(t,p)
%
% Input Variables
%   t - time points at which to generate ECG signal
%   p - parameters to generate signal
%   p.RVep - right venticular epicaridal parameters
%   p.RVen - right venticular endocaridal parameters
%   p.LVep - left venticular epicaridal parameters
%   p.LVen - left venticular endocaridal parameters
%   p.*.mag - magnitude of coresponding signal
%   p.*.sig - sigmoid parameters [slopeStart start slopeEnd end]
%
% Output Variables
%   ecg - simulated ecg
%
% Description
%   Uses a model based approach to generate an ECG.

% Created
%   4/21/2006, Richard J. Povinelli, Marquette University
%
% Modified
%   Mohamed A Mneimneh, Marquette University
% 
% This software is released under the terms of the GNU General
% Public License (http://www.gnu.org/copyleft/gpl.html).

AVPos = p.AV.mag * diffsigmoid(t,p.AV.sig + [0 p.AV.posDelta1 0 p.AV.posDelta2]);
AVNeg = p.AV.mag * diffsigmoid(t,p.AV.sig + [0 p.AV.posDelta1 0 p.AV.posDelta2]);

RVepPos = p.RVep.mag * diffsigmoid(t,p.RVep.sig + [0 p.RVep.posDelta1 0 p.RVep.posDelta2]);
RVenPos = p.RVen.mag * diffsigmoid(t,p.RVen.sig + [0 p.RVen.posDelta1 0 p.RVen.posDelta2]);
LVepPos = p.LVep.mag * diffsigmoid(t,p.LVep.sig + [0 p.LVep.posDelta1 0 p.LVep.posDelta2]);
LVenPos = p.LVen.mag * diffsigmoid(t,p.LVen.sig + [0 p.LVen.posDelta1 0 p.LVen.posDelta2]);
RVepNeg = p.RVep.mag * diffsigmoid(t,p.RVep.sig + [0 p.RVep.negDelta1 0 p.RVep.negDelta2]);
RVenNeg = p.RVen.mag * diffsigmoid(t,p.RVen.sig + [0 p.RVen.negDelta1 0 p.RVen.negDelta2]);
LVepNeg = p.LVep.mag * diffsigmoid(t,p.LVep.sig + [0 p.LVep.negDelta1 0 p.LVep.negDelta2]);
LVenNeg = p.LVen.mag * diffsigmoid(t,p.LVen.sig + [0 p.LVen.negDelta1 0 p.LVen.negDelta2]);


% ecg = RVenPos - RVenNeg + ...
%       LVepPos - LVepNeg + ...
%       LVenPos - LVenNeg;
ecg = AVPos - AVNeg   + ...
    RVepPos - RVepNeg + ...
    RVenPos - RVenNeg + ...
    LVepPos - LVepNeg + ...
    LVenPos - LVenNeg;


if nargin == 3 %debug
    %     AVInt   =  Lintersect(AVPos,AVNeg);
    RVepInt =  Lintersect(RVepPos,RVepNeg);
    RVenInt =  Lintersect(RVenPos,RVenNeg);
    LVepInt =  Lintersect(LVepPos,LVepNeg);
    LVenInt =  Lintersect(LVenPos,LVenNeg);

end %if